using System;
using System.Collections.Generic;
using System.Text;
using ESRI.ArcGIS.Geoprocessor;
using ESRI.ArcGIS.Geoprocessing;

namespace GeoprocessingExample1
{
    class Program
    {
        static void Main(string[] args)
        {
            // Create the geoprocessor object
            Geoprocessor gp = new Geoprocessor();
            // Set the workspace
            gp.SetEnvironmentValue("workspace", @"C:\Data");
            // Get enumeration of workspace objects 
            //   in C:\(geodatabases)
            IGpEnumList gdbs = gp.ListWorkspaces("", "");
            string gdb = gdbs.Next();
            // Enumerate through the geodatabase, print out 
            //   featureclass names to standard output
            while (gdb != "")
            {
                Console.WriteLine(gdb.ToString());
                gp.SetEnvironmentValue("workspace", gdb);
                IGpEnumList fcs = gp.ListFeatureClasses("", "", "");
                string fc = fcs.Next();
                while (fc != "")
                {
                    Console.WriteLine(fc.ToString());
                    fc = fcs.Next();
                }
                gdb = gdbs.Next();
            }
        }
    }
}
