using System;
using System.Collections.Generic;
using System.Text;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.esriSystem;
using ESRI.ArcGIS.DataSourcesGDB;

namespace ConnectToSde
{
    class Program
    {
        public static List<string> FetchSdeFcList(string inWs, string dbType)
        {
            List<string> fcsList = new List<string>();
            IWorkspaceFactory2 wsf = new SdeWorkspaceFactoryClass();
            IPropertySet ps = new PropertySetClass();
            if (dbType == "enterprise")
            {
                // Enterprise SDE SQL Server 2005
                // Server name
                ps.SetProperty("SERVER", "server");
                // Server instance
                ps.SetProperty("INSTANCE", "sde:sqlserver:server");
                // Authentication mode: database
                ps.SetProperty("AUTHENTICATION_MODE", "DBMS");
                // Since using database authentication, we must pass in
                //   credentials
                ps.SetProperty("USER", "user");
                ps.SetProperty("PASSWORD", "password");
                // Database name
                ps.SetProperty("DATABASE", "sde");
                // Database version
                ps.SetProperty("VERSION", "sde.DEFAULT");
            }
            else
            {
                // Workgroup SDE SQL Server Express 2008
                ps.SetProperty("SERVER", "server_sqlexpress");
                ps.SetProperty("INSTANCE", 
                               "sde:sqlserver:server\\sqlexpress");
                // Here we use operating system authentication (OSA), so we 
                //   don't need to supply credentials (username and password)
                ps.SetProperty("AUTHENTICATION_MODE", "OSA");
                ps.SetProperty("DATABASE", "SWNGIS");
                ps.SetProperty("VERSION", "dbo.DEFAULT");
            }
            // Open up the workspace connection
            IWorkspace ws = wsf.Open(ps, 0);
            IFeatureWorkspace fws = (IFeatureWorkspace)wsf.Open(ps, 0);
            // Open the featuredataset we specify as an input argument
            IFeatureClassContainer fcc = 
                        (IFeatureClassContainer)fws.OpenFeatureDataset(inWs);
            // Get an enumeration of the featureclasses in the featuredataset
            IEnumFeatureClass efc = fcc.Classes;
            IFeatureClass fc = efc.Next();
            // Run through the enumeration
            while (fc != null)
            {
                Console.WriteLine(fc.AliasName);
                fc = efc.Next();
            }
            return fcsList;
        }


        static void Main(string[] args)
        {
            // Fetch a license and initialize it
            IAoInitialize aoInit = new AoInitializeClass();
            aoInit.Initialize(
                      esriLicenseProductCode.esriLicenseProductCodeArcInfo);
            // Call our method, passing in arguments: 1) featuredataset name 
            //   2) SDE type - workgroup or enterprise
            FetchSdeFcList("SWNGIS.DBO.Wells", "workgroup");
        }
    }
}
