using System;
using System.Collections.Generic;
using System.Text;
using ESRI.ArcGIS.Server;

namespace AgsGetServices
{
    class Program
    {
        static void Main(string[] args)
        {
            GISServerConnection conn = null;
            IServerObjectAdmin4 soa = null;

            conn = new GISServerConnection();
            conn.Connect("server");

            soa = (IServerObjectAdmin4)conn.ServerObjectAdmin;
            IEnumServerObjectConfiguration enumConfig = 
                                      soa.GetConfigurations();
            IServerObjectConfigurationStatus configStatus = null;
            IServerObjectConfiguration config = enumConfig.Next();
            config.WaitTimeout = 600;
            while (config != null)
            {
                configStatus = soa.GetConfigurationStatus(
                                   config.Name, config.TypeName);
                Console.WriteLine(String.Concat("Service ", 
                                                config.Name,
                                                " is " , 
                                                configStatus.Status));
                config = enumConfig.Next();
            }
        }
    }
}