Public Class Label

  Private m_sText As String
  Private m_sFontName As String
  Private m_iFontSize As String
  Private m_sFontColor As String
  Private m_eAlignment As TextAlignment
  Private m_sOutlineColor As String
  Private m_bAntiAliasing As Boolean
  Private m_iInterval As Integer

  Enum TextAlignment
    alignLeft = 0
    alignCenter = 1
    alignRight = 2
  End Enum

  Public Sub New( _
                  ByVal Text As String, _
                  ByVal FontName As String, _
                  ByVal FontSize As Integer, _
                  ByVal FontColor As String, _
                  ByVal Alignment As TextAlignment, _
                  ByVal AntiAliasing As Boolean, _
                  ByVal Interval As Integer _
                )

    m_sText = Text
    m_sFontName = FontName
    m_iFontSize = FontSize
    m_sFontColor = FontColor
    m_eAlignment = Alignment
    m_bAntiAliasing = AntiAliasing
    m_iInterval = Interval
    m_sOutlineColor = Nothing

  End Sub

  Public Sub New( _
                  ByVal Text As String, _
                  ByVal FontName As String, _
                  ByVal FontSize As Integer, _
                  ByVal FontColor As String, _
                  ByVal Alignment As TextAlignment, _
                  ByVal AntiAliasing As Boolean, _
                  ByVal Interval As Integer, _
                  ByVal OutlineColor As String _
                )

    m_sText = Text
    m_sFontName = FontName
    m_iFontSize = FontSize
    m_sFontColor = FontColor
    m_eAlignment = Alignment
    m_bAntiAliasing = AntiAliasing
    m_iInterval = Interval
    m_sOutlineColor = OutlineColor

  End Sub

  Public ReadOnly Property Text()
    Get
      Return m_sText
    End Get
  End Property

  Public ReadOnly Property FontName()
    Get
      Return m_sFontName
    End Get
  End Property

  Public ReadOnly Property FontSize() As Integer
    Get
      Return m_iFontSize
    End Get
  End Property

  Public ReadOnly Property FontColor() As String
    Get
      Return m_sFontColor
    End Get
  End Property

  Public ReadOnly Property Alignment()
    Get
      Return m_eAlignment
    End Get
  End Property

  Public ReadOnly Property OutlineColor()
    Get
      Return m_sOutlineColor
    End Get
  End Property

  Public ReadOnly Property AntiAliasing()
    Get
      Return m_bAntiAliasing
    End Get
  End Property

  Public ReadOnly Property Interval()
    Get
      Return m_iInterval
    End Get
  End Property

  Public Function GetAsLabelDesc() As ArcWeb_MapImage.LabelDescription

    Dim objLabelDescription As New ArcWeb_MapImage.LabelDescription

    objLabelDescription.font = Me.FontName
    objLabelDescription.fontStyle = "regular"
    objLabelDescription.fontSize = Me.FontSize
    objLabelDescription.fontColor = Me.FontColor

    Select Case Me.Alignment
      Case Me.TextAlignment.alignCenter
        objLabelDescription.halignment = "center"
      Case Me.TextAlignment.alignLeft
        objLabelDescription.halignment = "left"
      Case Me.TextAlignment.alignRight
        objLabelDescription.halignment = "right"
    End Select

    If Not Me.OutlineColor Is Nothing Then
      objLabelDescription.outlineColor = Me.OutlineColor
    End If

    objLabelDescription.interval = Me.Interval
    objLabelDescription.antialiasing = Me.AntiAliasing

    Return objLabelDescription

  End Function

End Class
