Option Strict On

Public MustInherit Class Layer
' -----------------------------------------------------------------
'                   Site Starters Application Code
'              Environmental Systems Research Institute
' -----------------------------------------------------------------
'  Purpose  : Models a layer that can be drawn in the viewer.
' -----------------------------------------------------------------
'  Notes    :
' -----------------------------------------------------------------
'  History  :
'  =================================================================

  Private m_sName As String
  Private m_sDataSource As String
  Private m_bVisible As Boolean

' ******************************************************************
' *****************  CONSTRUCTOR / DESTRUCTOR  *********************
' ******************************************************************

  Public Sub New( _
                 ByVal Name As String, _
                 ByVal DataSource As String, _
                 ByVal Visible As Boolean _
                 )

    m_sName = Name
    m_sDataSource = DataSource
    m_bVisible = Visible

  End Sub

' ******************************************************************
' *********************  PUBLIC PROPERTIES  ************************
' ******************************************************************

  Public ReadOnly Property Name() As String
    Get
      Return m_sName
    End Get
  End Property

  Public Property Visible() As Boolean
    Get
      Return m_bVisible
    End Get
    Set(ByVal Visible As Boolean)
      m_bVisible = Visible
    End Set
  End Property


' ******************************************************************
' *******************  PROTECTED PROPERTIES  ***********************
' ******************************************************************

  Protected ReadOnly Property DataSource() As String
    Get
      Return m_sDataSource
    End Get
  End Property

  Protected Function MakeMapImageSize( _
                                  ByVal iWidthPixels As Integer, _
                                  ByVal iHeightPixels As Integer _
                                ) As ArcWeb_MapImage.MapImageSize

    Dim objMapImageSize As New ArcWeb_MapImage.MapImageSize

    objMapImageSize.width = iWidthPixels
    objMapImageSize.height = iHeightPixels

    Return objMapImageSize

  End Function

  Protected Function Rect2Env(ByVal rctExtent As Rect) As ArcWeb_MapImage.Envelope
    Dim envExtent As New ArcWeb_MapImage.Envelope
    With envExtent
      .minx = rctExtent.XMin
      .miny = rctExtent.YMin
      .maxx = rctExtent.XMax
      .maxy = rctExtent.YMax
    End With
    Return envExtent
  End Function

  Protected Function CopyMarkers(ByVal lstMarkerDesc As ArrayList) As ArcWeb_MapImage.MarkerDescription()

      ' copy to honest to goodness marker array.

    Dim arrMarkerDesc(lstMarkerDesc.Count - 1) As ArcWeb_MapImage.MarkerDescription
    Dim i As Integer
    For i = 0 To lstMarkerDesc.Count - 1
      arrMarkerDesc(i) = (CType(lstMarkerDesc(i), Marker)).GetAsMarkerDesc
    Next
    Return arrMarkerDesc

  End Function


  Protected Function MakeMapImageOptions( _
                                        ByVal sDataSource As String, _
                                        ByVal objMapImageSize As ArcWeb_MapImage.MapImageSize, _
                                        ByVal bLegend As Boolean, _
                                        ByVal arrMarkerDesc As ArcWeb_MapImage.MarkerDescription(), _
                                        ByVal arrDisplayLayers As ArcWeb_MapImage.Layer() _
                                      ) As ArcWeb_MapImage.MapImageOptions

    Dim objMapImageOptions As New ArcWeb_MapImage.MapImageOptions

    If Not arrDisplayLayers Is Nothing Then
     If arrDisplayLayers.Length > 0 Then
      objMapImageOptions.displayLayers = arrDisplayLayers
     End If
    End If

    If Not arrMarkerDesc Is Nothing Then
      If arrMarkerDesc.Length > 0 Then
        objMapImageOptions.markers = arrMarkerDesc
      End If
    End If

    objMapImageOptions.mapImageSize = objMapImageSize
    objMapImageOptions.drawScaleBar = True
    objMapImageOptions.returnLegend = bLegend
    objMapImageOptions.dataSource = sDataSource

    Return objMapImageOptions

  End Function



' ******************************************************************
' **********************  PUBLIC METHODS  **************************
' ******************************************************************


' ******************************************************************
' ********************  PRIVATE FUNCTIONS  *************************
' ******************************************************************


End Class
