Option Strict On

Public Class MapImageLayer
' -----------------------------------------------------------------
'                   Site Starters Application Code
'              Environmental Systems Research Institute
' -----------------------------------------------------------------
'  Purpose  : 
' -----------------------------------------------------------------
'  Notes    :
' -----------------------------------------------------------------
'  History  :
'  =================================================================

  Inherits Layer

  Private m_tblLayerVisibilities As New Hashtable

' ******************************************************************
' *****************  CONSTRUCTOR / DESTRUCTOR  *********************
' ******************************************************************

  Public Sub New( _
                  ByVal Name As String, _
                  ByVal Datasource As String, _
                  ByVal Visible As Boolean _
                 )

    MyBase.New(Name, Datasource, Visible)

  End Sub


' ******************************************************************
' *********************  PUBLIC PROPERTIES  ************************
' ******************************************************************

  Public Overloads Function GetLegend(ByRef rctExtent As Rect, _
                            ByVal MapWidthPixels As Integer, _
                            ByVal MapHeightPixels As Integer, _
                            ByVal Token As String _
                            ) As String


    Dim objMapImageOptions As ArcWeb_MapImage.MapImageOptions
    Dim objMapImage As New ArcWeb_MapImage.MapImage
    Dim objMapImageInfo As ArcWeb_MapImage.MapImageInfo

    objMapImageOptions = MakeMapImageOptions( _
                                              MyBase.DataSource, _
                                              MyBase.MakeMapImageSize(MapWidthPixels, MapHeightPixels), _
                                              True, _
                                              Nothing, _
                                              MakeDisplayLayerArray(m_tblLayerVisibilities) _
                                            )

      objMapImageInfo = objMapImage.getMap( _
                                            rect2env(rctExtent), _
                                            objMapImageOptions, _
                                            Token _
                                          )

    Return objMapImageInfo.legendUrl

  End Function

  Public Function GetMap( _
                          ByRef rctExtent As Rect, _
                          ByVal MapWidthPixels As Integer, _
                          ByVal MapHeightPixels As Integer, _
                          ByVal lstMarkerDesc As ArrayList, _
                          ByVal Token As String _
                          ) As String

    Dim objMapImageOptions As ArcWeb_MapImage.MapImageOptions
    Dim objMapImage As New ArcWeb_MapImage.MapImage
    Dim objMapImageInfo As ArcWeb_MapImage.MapImageInfo

    objMapImageOptions = MakeMapImageOptions( _
                                              MyBase.DataSource, _
                                              MakeMapImageSize(MapWidthPixels, MapHeightPixels), _
                                              False, _
                                              MyBase.CopyMarkers(lstMarkerDesc), _
                                              MakeDisplayLayerArray(m_tblLayerVisibilities) _
                                            )


      objMapImageInfo = objMapImage.getMap( _
                                            rect2env(rctExtent), _
                                            objMapImageOptions, _
                                            Token _
                                          )

    Return objMapImageInfo.mapUrl

  End Function

  Public Sub SetLayerVisibility(ByVal Name As String, ByVal Visible As Boolean)
    If m_tblLayerVisibilities.ContainsKey(Name) Then
      m_tblLayerVisibilities.Remove(Name)
    End If
    m_tblLayerVisibilities.Add(Name, Visible)
  End Sub

  Public Sub ClearLayerVisibility(ByVal Name As String)
    If m_tblLayerVisibilities.ContainsKey(Name) Then
      m_tblLayerVisibilities.Remove(Name)
    End If
  End Sub

' ******************************************************************
' ********************  PRIVATE FUNCTIONS  *************************
' ******************************************************************

  Private Function MakeDisplayLayerArray(ByVal tblLayerVisibilities As Hashtable) As ArcWeb_MapImage.Layer()

    Dim lyrCurrent As ArcWeb_MapImage.Layer
    Dim arrReturn As ArcWeb_MapImage.Layer()
    Dim objEnumerator As IDictionaryEnumerator = tblLayerVisibilities.GetEnumerator()
    Dim i As Integer

    ReDim arrReturn(tblLayerVisibilities.Count - 1)

    i = 0
    While objEnumerator.MoveNext
      lyrCurrent = New ArcWeb_MapImage.Layer
      lyrCurrent.layerName = CStr(objEnumerator.Key)
      If CBool(objEnumerator.Value) Then
        lyrCurrent.visibility = "on"
      Else
        lyrCurrent.visibility = "off"
      End If
      arrReturn(i) = lyrCurrent
      i = i + 1
    End While

    Return arrReturn

  End Function



End Class
