Public Class Marker

  Private m_ptLocation As Point
  Private m_objLabel As Label
  Private m_sIconName As String
  Private m_sIconDataset As String

  Public Sub New( _
                  ByVal Location As Point, _
                  ByVal IconName As String, _
                  ByVal IconDataset As String _
                  )

    m_ptLocation = Location
    m_sIconName = IconName
    m_sIconDataset = IconDataset

  End Sub

  Public Sub New( _
                  ByVal Location As Point, _
                  ByVal IconName As String, _
                  ByVal IconDataset As String, _
                  ByVal Label As Label _
                  )

    m_ptLocation = Location
    m_sIconName = IconName
    m_sIconDataset = IconDataset
    m_objLabel = Label

  End Sub

  Public Sub New( _
                  ByVal Location As Point, _
                  ByVal Label As Label _
                )

    m_ptLocation = Location
    m_objLabel = Label

  End Sub

  Public Function GetAsMarkerDesc() As ArcWeb_MapImage.MarkerDescription

    Dim ptLocation As New ArcWeb_MapImage.Point
    ptLocation.x = m_ptLocation.X
    ptLocation.y = m_ptLocation.Y

    Dim objMarkerDesc As New ArcWeb_MapImage.MarkerDescription
    objMarkerDesc.location = ptLocation

    If Not m_sIconDataset Is Nothing And _
       Not m_sIconName Is Nothing Then
      objMarkerDesc.iconDataSource = m_sIconDataset
      objMarkerDesc.name = m_sIconName
    End If

    If Not m_objLabel Is Nothing Then

      objMarkerDesc.labelDescription = m_objLabel.GetAsLabelDesc
      objMarkerDesc.label = m_objLabel.Text

    End If

    Return objMarkerDesc

  End Function


End Class
