Option Strict On

Public Class Point
' -----------------------------------------------------------------
'                   Site Starters Application Code
'              Environmental Systems Research Institute
' -----------------------------------------------------------------
'  Class    : cPoint
'  Purpose  : Represents a geometric point (x,y pair).
' -----------------------------------------------------------------
'  Notes    :
' -----------------------------------------------------------------
'  History  :
'  =================================================================

  Private m_dblX As Double
  Private m_dblY As Double

  ' ******************************************************************
  ' ******************** CONSTRUCTOR/DESTRUCTOR **********************
  ' ******************************************************************

  Public Sub New(ByVal X As Double, ByVal Y As Double)
    m_dblX = X
    m_dblY = Y
  End Sub

  ' ******************************************************************
  ' ********************** PUBLIC PROPERTIES *************************
  ' ******************************************************************

  Public ReadOnly Property X() As Double
    Get
      Return m_dblX
    End Get
  End Property

  Public ReadOnly Property Y() As Double
    Get
      Return m_dblY
    End Get
  End Property

  ' ******************************************************************
  ' ********************** PUBLIC METHODS *************************
  ' ******************************************************************

  Public Function Clone() As Point
    Return New Point(m_dblX, m_dblY)
  End Function

  Public Function DistanceTo(ByVal ComparePoint As Point) As Double
    Return Math.Sqrt(Math.Pow((ComparePoint.X - m_dblX), 2) + Math.Pow((ComparePoint.Y - m_dblY), 2))
  End Function

End Class
