Option Strict On

Public Class Rect
' -----------------------------------------------------------------
'                 Site Starters Application Code
'             Environmental Systems Research Institute
'  -----------------------------------------------------------------
'  Class    : cRect
'  Purpose  : Represents a rectangle.
'  -----------------------------------------------------------------
'  Notes    :
'  -----------------------------------------------------------------
'  History  :
'  =================================================================

  Private m_dblXMin As Double
  Private m_dblYMin As Double
  Private m_dblXMax As Double
  Private m_dblYMax As Double

  ' ******************************************************************
  ' ******************** CONSTRUCTOR/DESTRUCTOR **********************
  ' ******************************************************************

  Public Sub New(ByVal XMin As Double, _
                 ByVal YMin As Double, _
                 ByVal XMax As Double, _
                 ByVal YMax As Double)

    m_dblXMin = XMin
    m_dblXMax = XMax
    m_dblYMin = YMin
    m_dblYMax = YMax

  End Sub

  Public Sub New(ByVal Center As Point, _
                 ByVal Width As Double, _
                 ByVal Height As Double)

    BuildFromCenter(Center, Width, Height)

  End Sub

  ' ******************************************************************
  ' ********************** PUBLIC PROPERTIES *************************
  ' ******************************************************************

  Public Property Center() As Point
    Set(ByVal pntCenter As Point)
      BuildFromCenter(New Point(pntCenter.X, pntCenter.Y), Me.Width, Me.Height)
    End Set
    Get
      Return New Point((m_dblXMin + ((m_dblXMax - m_dblXMin) / 2)), _
                       (m_dblYMin + ((m_dblYMax - m_dblYMin) / 2)))
    End Get
  End Property

  Public ReadOnly Property Clone() As Rect
    Get
      Return New Rect(m_dblXMin, _
                      m_dblYMin, _
                      m_dblXMax, _
                      m_dblYMax)
    End Get
  End Property

  Public ReadOnly Property Height() As Double
    Get
      Return (m_dblYMax - m_dblYMin)
    End Get
  End Property

  Public ReadOnly Property Width() As Double
    Get
      Return (m_dblXMax - m_dblXMin)
    End Get
  End Property

  Public ReadOnly Property XMax() As Double
    Get
      Return m_dblXMax
    End Get
  End Property

  Public ReadOnly Property XMin() As Double
    Get
      Return m_dblXMin
    End Get
  End Property

  Public ReadOnly Property YMax() As Double
    Get
      Return m_dblYMax
    End Get
  End Property

  Public ReadOnly Property YMin() As Double
    Get
      Return m_dblYMin
    End Get
  End Property

  ' ******************************************************************
  ' *********************** PUBLIC METHODS ***************************
  ' ******************************************************************

  Public Sub Scale(ByVal Factor As Double)

     ' A value between 0 and 1 decreases the size of the 
     ' rectangle and a value greater than 1 increases 
     ' the rectangle.

    BuildFromCenter(Me.Center, Me.Width * Factor, Me.Height * Factor)

  End Sub

  ' ******************************************************************
  ' ************************ PRIVATE SUBS ****************************
  ' ******************************************************************

  Private Sub BuildFromCenter(ByVal pntCenter As Point, _
                              ByVal dblWidth As Double, _
                              ByVal dblHeight As Double)

    m_dblXMin = pntCenter.X - (dblWidth / 2)
    m_dblYMin = pntCenter.Y - (dblHeight / 2)
    m_dblXMax = pntCenter.X + (dblWidth / 2)
    m_dblYMax = pntCenter.Y + (dblHeight / 2)

  End Sub

End Class
