Public Class WeatherRequestManager

  Private m_sDataSource As String

  Public Sub New(ByVal sWeatherDataSource)
    m_sDataSource = sWeatherDataSource
  End Sub


  Public Function FindWithin( _
                             ByVal Point As Point, _
                             ByVal DistanceInMiles As Double, _
                             ByVal MaxFeatures As Integer, _
                             ByVal sToken As String, _
                             Optional ByVal sWhereClause As String = Nothing _
                             ) As ArrayList

    Dim objSearchPoint As New ArcWeb_Proximity.Point
    Dim objProximity As New ArcWeb_Proximity.Proximity
    Dim objOptions As New ArcWeb_Proximity.ProximityOptions
    Dim objResultRange As New ArcWeb_Proximity.ResultSetRange

    Dim objResultSet As ArcWeb_Proximity.ResultSet

    objSearchPoint.x = Point.X
    objSearchPoint.y = Point.Y

    objResultRange.count = MaxFeatures

    objOptions.dataSource = m_sDataSource
    objOptions.resultRange = objResultRange
    objOptions.units = "miles"

    If Not sWhereClause Is Nothing Then
      objOptions.whereClause = sWhereClause
    End If

    objResultSet = objProximity.findWithin( _
                                    objSearchPoint, _
                                    DistanceInMiles, _
                                    objOptions, _
                                    sToken _
                                   )

    Dim i As Integer
    Dim arrReturn As New ArrayList

    For i = 0 To objResultSet.rows.Length - 1
      arrReturn.Add(New WeatherResult( _
                                       GetRSetValue(objResultSet, i, "STATIONID"), _
                                       New Point(GetRSetValue(objResultSet, i, "Longitude"), GetRSetValue(objResultSet, i, "Latitude")), _
                                       GetRSetValue(objResultSet, i, "CITY"), _
                                       GetRSetValue(objResultSet, i, "CURRENTWX"), _
                                       CDbl(GetRSetValue(objResultSet, i, "TEMPERATUR")), _
                                       CDbl(GetRSetValue(objResultSet, i, "HUMIDITY")), _
                                       CDbl(GetRSetValue(objResultSet, i, "VISIBILITY")), _
                                       CDbl(GetRSetValue(objResultSet, i, "DEWPOINT")), _
                                       CDbl(GetRSetValue(objResultSet, i, "SLPRESSURE")), _
                                       CInt(GetRSetValue(objResultSet, i, "WINDSPEED")), _
                                       CInt(GetRSetValue(objResultSet, i, "WINDDIR")), _
                                       GetRSetValue(objResultSet, i, "VALIDTIME"), _
                                       GetRSetValue(objResultSet, i, "COUNTY"), _
                                       GetRSetValue(objResultSet, i, "STATE_PROVINCE") _
                                      ) _
                   )
    Next

    Return arrReturn

  End Function

  Private Function GetRSetValue(ByVal ResultSet As ArcWeb_Proximity.ResultSet, _
                                ByVal Record As Integer, _
                                ByVal FieldName As String) As String

    Dim tblFieldIndexLUT As Hashtable = MakeFieldIndexLUT(ResultSet.fields)
    Dim iFieldIndex = tblFieldIndexLUT.Item(LCase(FieldName))
    Return ResultSet.rows(Record).fieldValues(iFieldIndex)

  End Function

  Private Function MakeFieldIndexLUT(ByVal arrFieldDesc As ArcWeb_Proximity.FieldDesc()) As Hashtable

  Dim i As Integer
  Dim tblReturn As New Hashtable

    For i = 0 To arrFieldDesc.Length - 1
      tblReturn.Add(arrFieldDesc(i).fieldName.ToLower, i)
    Next

    Return tblReturn

  End Function

End Class


