Public Class WeatherResult

  Public Enum Condition As Integer
    condition_Fair = 1
    condition_PartlyCloudy = 2
    condition_Cloudy = 3
    condition_Dust = 4
    condition_MostlySunny = 5
    condition_Fog = 6
    condition_VeryHot = 7
    condition_Haze = 8
    condition_VeryCold = 9
    condition_SnowShowers = 10
    condition_Smoke = 11
    condition_Drizzle = 12
    condition_Flurries = 13
    condition_Windy = 14
    condition_RainSnowMix = 15
    condition_Blizzard = 16
    condition_BlowingSnow = 17
    condition_Rain = 18
    condition_Snow = 19
    condition_Thunderstorms = 20
    condition_Sunny = 21
    condition_Clear = 22
    condition_RainShowers = 23
    condition_Sleet = 24
    condition_FreezingRain = 25
    condition_FreezingDrizzle = 26
  End Enum

  Private m_eCondition As Condition
  Private m_sDescription As String
  Private m_sImageName As String
  Private m_sStationID As String
  Private m_sCity As String
  Private m_dblTemperature As Double
  Private m_iHumidity As Integer
  Private m_ptLocation As Point
  Private m_dblDewPoint As Double
  Private m_dblPressure As Double
  Private m_iWindSpeed As Integer
  Private m_iWindDirection As Integer
  Private m_dblVisibility As Double
  Private m_sObservationTime As String
  Private m_sCounty As String
  Private m_sState As String
  
  ' lon, lat, curcondimage, curcondtext, temp, humidity, dewpoint, pressure, wind, visibility, precip, time

  Public Sub New( _
                  ByVal StationID As String, _
                  ByVal Location As Point, _
                  ByVal City As String, _
                  ByVal Condition As Condition, _
                  ByVal Temperature As Double, _
                  ByVal Humidity As Integer, _
                  ByVal Visibility As Double, _
                  ByVal DewPoint As Double, _
                  ByVal Pressure As Double, _
                  ByVal WindSpeed As Integer, _
                  ByVal WindDirection As Integer, _
                  ByVal ObservationTime As String, _
                  ByVal County As String, _
                  ByVal State As String _
                )

    m_sStationID = StationID
    m_ptLocation = Location
    m_eCondition = Condition
    m_sCity = City
    m_dblTemperature = Temperature
    m_iHumidity = Humidity
    m_dblDewPoint = DewPoint
    m_dblPressure = Pressure
    m_iWindSpeed = WindSpeed
    m_iWindDirection = WindDirection
    m_dblVisibility = Visibility
    m_sObservationTime = ObservationTime
    m_sCounty = County
    m_sState = State
    LookUpValues()

  End Sub

  Public ReadOnly Property County() As String
    Get
      Return m_sCounty
    End Get
  End Property

  Public ReadOnly Property Description() As String
    Get
      Return m_sDescription
    End Get
  End Property

  Public ReadOnly Property DewPoint() As Double
    Get
      Return m_dblDewPoint
    End Get
  End Property

  Public ReadOnly Property Humidity() As Integer
    Get
      Return m_iHumidity
    End Get
  End Property

  Public ReadOnly Property Image() As String
    Get
      Return m_sImageName
    End Get
  End Property

  Public ReadOnly Property ID() As String
    Get
      Return m_sStationID
    End Get
  End Property

  Public ReadOnly Property Location() As Point
    Get
      Return m_ptLocation
    End Get
  End Property

  Public ReadOnly Property City() As String
    Get
      Return m_sCity
    End Get
  End Property

  Public ReadOnly Property Pressure() As Double
    Get
      Return m_dblPressure
    End Get
  End Property

  Public ReadOnly Property State() As String
    Get
      Return m_sState
    End Get
  End Property

  Public ReadOnly Property Temperature() As Double
    Get
      Return m_dblTemperature
    End Get
  End Property

  Public ReadOnly Property WindSpeed() As Integer
    Get
      Return m_iWindSpeed
    End Get
  End Property

  Public ReadOnly Property WindDirection() As Integer
    Get
      Return m_iWindDirection
    End Get
  End Property

  Public ReadOnly Property Visibility() As Double
    Get
      Return m_dblVisibility
    End Get
  End Property

  Public ReadOnly Property ObservationTime() As String
    Get
      Return m_sObservationTime
    End Get
  End Property

  Public ReadOnly Property Formatted_Wind() As String
    Get

      Dim sWindSpeed = CStr(m_iWindSpeed) & " knots"

      If m_iWindSpeed <> 0 Then

        Dim sWindDir As String

        If m_iWindDirection < 25 Or m_iWindDirection > 335 Then
          sWindDir = "from the North"
        ElseIf m_iWindDirection > 25 And m_iWindDirection < 65 Then
          sWindDir = "from the Northeast"
        ElseIf m_iWindDirection > 65 And m_iWindDirection < 115 Then
          sWindDir = "from the East"
        ElseIf m_iWindDirection > 115 And m_iWindDirection < 155 Then
          sWindDir = "from the Southeast"
        ElseIf m_iWindDirection > 155 And m_iWindDirection < 205 Then
          sWindDir = "from the South"
        ElseIf m_iWindDirection > 205 And m_iWindDirection < 245 Then
          sWindDir = "from the Southwest"
        ElseIf m_iWindDirection > 245 And m_iWindDirection < 295 Then
          sWindDir = "from the West"
        ElseIf m_iWindDirection > 295 And m_iWindDirection < 335 Then
          sWindDir = "from the Northwest"
        End If

        sWindSpeed = sWindSpeed & " " & sWindDir

      End If

      Return sWindSpeed

    End Get

  End Property

  Private Sub LookUpValues()
      Select Case m_eCondition
        Case Condition.condition_Fair
          m_sImageName = "Fair_sm.gif"
          m_sDescription = "Fair"
        Case Condition.condition_PartlyCloudy
          m_sImageName = "PartlyCloudy_sm.gif"
          m_sDescription = "Partly Cloudy"
        Case Condition.condition_Cloudy
          m_sImageName = "Cloudy_sm.gif"
          m_sDescription = "Cloudy"
        Case Condition.condition_Dust
          m_sImageName = ""
          m_sDescription = "Dust"
        Case Condition.condition_MostlySunny
          m_sImageName = "MostlySunny_sm.gif"
          m_sDescription = "Mostly Sunny"
        Case Condition.condition_Fog
          m_sImageName = "Fog_sm.gif"
          m_sDescription = "Fog"
        Case Condition.condition_VeryHot
          m_sImageName = "VeryHot_sm.gif"
          m_sDescription = "Very Hot"
        Case Condition.condition_Haze
          m_sImageName = "Haze_sm.gif"
          m_sDescription = "Haze"
        Case Condition.condition_VeryCold
          m_sImageName = "VeryCold_sm.gif"
          m_sDescription = "Very Cold"
        Case Condition.condition_SnowShowers
          m_sImageName = "SnowShowers_sm.gif"
          m_sDescription = "Snow Showers"
        Case Condition.condition_Smoke
          m_sImageName = "Smoke_sm.gif"
          m_sDescription = "Smoke"
        Case Condition.condition_Drizzle
          m_sImageName = "Drizzle_sm.gif"
          m_sDescription = "Drizzle"
        Case Condition.condition_Flurries
          m_sImageName = "Flurries_sm.gif"
          m_sDescription = "Flurries"
        Case Condition.condition_Windy
          m_sImageName = "Windy_sm.gif"
          m_sDescription = "Windy"
        Case Condition.condition_RainSnowMix
          m_sImageName = "RainSnowMix_sm.gif"
          m_sDescription = "Rain/Snow Mix"
        Case Condition.condition_Blizzard
          m_sImageName = "Blizzard_sm.gif"
          m_sDescription = "Blizzard"
        Case Condition.condition_BlowingSnow
          m_sImageName = "BlowingSnow_sm.gif"
          m_sDescription = "Blowing Snow"
        Case Condition.condition_Rain
          m_sImageName = "Rain_sm.gif"
          m_sDescription = "Rain"
        Case Condition.condition_Snow
          m_sImageName = "Snow_sm.gif"
          m_sDescription = "Snow"
        Case Condition.condition_Thunderstorms
          m_sImageName = "Thunderstorms_sm.gif"
          m_sDescription = "Thunderstorms"
        Case Condition.condition_Sunny
          m_sImageName = "Sunny_sm.gif"
          m_sDescription = "Sunny"
        Case Condition.condition_Clear
          m_sImageName = "Clear_sm.gif"
          m_sDescription = "Clear"
        Case Condition.condition_RainShowers
          m_sImageName = "RainShowers_sm.gif"
          m_sDescription = "Rain Showers"
        Case Condition.condition_Sleet
          m_sImageName = "Sleet_sm.gif"
          m_sDescription = "Sleet"
        Case Condition.condition_FreezingRain
          m_sImageName = "FreezingRain_sm.gif"
          m_sDescription = "Freezing Rain"
        Case Condition.condition_FreezingDrizzle
          m_sImageName = "FreezingRain_sm.gif"
          m_sDescription = "Freezing Drizzle"
        Case Else
      End Select

  End Sub

End Class
