Imports System.Web
Imports System.Web.SessionState

Public Class Global

  Inherits System.Web.HttpApplication

  Const WEATHER_DATASOURCE = "MX.CurrentWeather.NA"
  Const SEARCH_RADIUS = 100
  Const MAX_FEATURES = 1

  Private Enum Location_Type
    ltRegionalOffice = 0
    ltAirport = 1
  End Enum

  Private Enum LogEntryStatus
    Status_Information = 0
    Status_Warning = 2
    Status_Error = 3
  End Enum

#Region " Component Designer Generated Code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container
    End Sub

#End Region

  Sub Application_Start(ByVal sender As Object, ByVal e As EventArgs)

      ' Fires when the application is started      

    Application("RO Weather Results") = New System.Collections.Hashtable
    Application("RO Weather Map") = Nothing
    Application("Airport Weather Results") = New System.Collections.Hashtable
    Application("Airport Weather Map") = Nothing

    Application("Last RO Data Fetch") = Nothing
    Application("Last RO Map Fetch") = Nothing
    Application("Last Airport Data Fetch") = Nothing
    Application("Last Airport Map Fetch") = Nothing

    Application("Token") = Nothing
    Application("Last Token Fetch") = Nothing

    WriteToLog( _
                "Beginning application.", _
                LogEntryStatus.Status_Information _
              )

    ' Fetch token

    With ConfigurationSettings.AppSettings
      If Not (.Item("AUTHENTICATION_USER").ToString.Length > 0) Then
        Throw New Exception("Global account username missing from web.config.")
      End If
      If Not (.Item("AUTHENTICATION_PASSWORD").ToString.Length > 0) Then
        Throw New Exception("Global account password missing from web.config.")
      End If
      If Not (.Item("AUTHENTICATION_TIMEOUT").ToString.Length > 0) Then
        Throw New Exception("Authentication timeout value missing from web.config.")
      End If
    End With

    Try
      Application("Token") = GetToken( _
            ConfigurationSettings.AppSettings("AUTHENTICATION_USER"), _
            ConfigurationSettings.AppSettings("AUTHENTICATION_PASSWORD"), _
            ConfigurationSettings.AppSettings("AUTHENTICATION_TIMEOUT") _
                                      )
    Catch ex As System.Exception
      WriteToLog( _
                  "Error in Application_Start: Cannot retrieve token.", _
                  LogEntryStatus.Status_Error _
                )
      WriteToLog( _
                  "Aborting application...", _
                  LogEntryStatus.Status_Error _
                )
      Throw New Exception("Cannot get token")
    End Try

    Application("Last Token Fetch") = Date.Now

    Update_RO_WeatherData()
    Application("Last RO Data Fetch") = Date.Now

    Update_RO_Map()
    Application("Last RO Map Fetch") = Date.Now

    Update_Airport_WeatherData()
    Application("Last Airport Data Fetch") = Date.Now

    Update_Airport_Map()
    Application("Last Airport Map Fetch") = Date.Now

    Dim objTimer As New System.Timers.Timer
    objTimer.Enabled = True
    objTimer.Interval = 60000
    AddHandler objTimer.Elapsed, _
               New System.Timers.ElapsedEventHandler(AddressOf ProcessTimer)

  End Sub

  Sub Session_Start(ByVal sender As Object, ByVal e As EventArgs)

      ' Fires when the session is started     

    Dim sClientIPAddress As String = HttpContext. _
                                     Current. _
                                     Request. _
                                     UserHostAddress.ToString

    WriteToLog( _
               "Starting session " & Session.SessionID & _
               " for IP " & sClientIPAddress & ".", _
               LogEntryStatus.Status_Information _
               )

  End Sub
  Sub Application_BeginRequest(ByVal sender As Object, ByVal e As EventArgs)
      ' Fires at the beginning of each request
  End Sub
  Sub Application_AuthenticateRequest(ByVal sender As Object, ByVal e As EventArgs)
      ' Fires upon attempting to authenticate the use
  End Sub
  Sub Application_Error(ByVal sender As Object, ByVal e As EventArgs)

      ' Fires when an error occurs

    WriteToLog( _
                "Application error has occured.", _
                LogEntryStatus.Status_Error _
              )

  End Sub
  Sub Session_End(ByVal sender As Object, ByVal e As EventArgs)

      ' Fires when the session ends   

    WriteToLog( _
                "Ending session " & Session.SessionID & ".", _
                LogEntryStatus.Status_Information _
              )

  End Sub
  Sub Application_End(ByVal sender As Object, ByVal e As EventArgs)
      ' Fires when the application ends   

    WriteToLog( _
                "Application has stopped.", _
                LogEntryStatus.Status_Information _
              )

  End Sub

  ' *********************************************************************
  ' *************************** TIMER EVENTS ****************************
  ' *********************************************************************

  Private Sub ProcessTimer( _
                            ByVal sender As System.Object, _
                            ByVal e As System.Timers.ElapsedEventArgs _
                            )

    If DateDiff( _
                 DateInterval.Minute, _
                 Application("Last Token Fetch"), _
                 Date.Now _
                 ) >= _
        (ConfigurationSettings.AppSettings("AUTHENTICATION_TIMEOUT") - 1) Then

      Try
        Application.Lock()
        Application("Token") = GetToken( _
              ConfigurationSettings.AppSettings("AUTHENTICATION_USER"), _
              ConfigurationSettings.AppSettings("AUTHENTICATION_PASSWORD"), _
              ConfigurationSettings.AppSettings("AUTHENTICATION_TIMEOUT") _
                                        )
        Application("Last Token Fetch") = Date.Now
        WriteToLog( _
                "Successfully fetched new token at " & Date.Now & ".", _
                LogEntryStatus.Status_Information _
                  )
      Catch ex As System.Exception
        WriteToLog( _
                    "Error fetching token:" & ex.Message, _
                    LogEntryStatus.Status_Error _
                  )
      Finally
        Application.UnLock()
      End Try
    End If

    If DateDiff( _
                 DateInterval.Minute, _
                 Application("Last RO Map Fetch"), _
                 Date.Now _
                ) >= _
        (ConfigurationSettings.AppSettings("OFFICE_MAP_REQUEST_INTERVAL") - 1) Then

      Update_RO_Map()

      Try
        Application.Lock()
        Application("Last RO Map Fetch") = Date.Now
      Finally
        Application.UnLock()
      End Try

    End If


    ' Update RO data, if due.

    If DateDiff( _
                 DateInterval.Minute, _
                 Application("Last RO Data Fetch"), _
                 Date.Now _
                ) >= _
        (ConfigurationSettings.AppSettings("OFFICE_QUERY_INTERVAL") - 1) Then

      Update_RO_WeatherData()

      Try
        Application.Lock()
        Application("Last RO Data Fetch") = Date.Now
      Finally
        Application.UnLock()
      End Try

    End If


    ' Update airport data, if due.

    If DateDiff( _
                 DateInterval.Minute, _
                 Application("Last Airport Data Fetch"), _
                 Date.Now _
                ) >= _
        (ConfigurationSettings.AppSettings("AIRPORT_QUERY_INTERVAL") - 1) Then

      Update_Airport_WeatherData()

      Try
        Application.Lock()
        Application("Last Airport Data Fetch") = Date.Now
      Finally
        Application.UnLock()
      End Try

    End If


    ' Update airport map, if due.

    If DateDiff( _
                 DateInterval.Minute, _
                 Application("Last Airport Map Fetch"), _
                 Date.Now _
                ) >= _
        (ConfigurationSettings.AppSettings("AIRPORT_MAP_REQUEST_INTERVAL") - 1) Then

      Update_Airport_Map()

      Try
        Application.Lock()
        Application("Last Airport Map Fetch") = Date.Now
      Finally
        Application.UnLock()
      End Try

    End If


  End Sub

  ' *********************************************************************
  ' ************************ UPDATE FUNCTIONS ***************************
  ' *********************************************************************

  Private Sub Update_Airport_WeatherData()

    WriteToLog( _
                "Beginning airport weather data update.", _
                LogEntryStatus.Status_Information _
              )

    Dim objConfigHandler As New SectionHandler_Locations
    Dim arrAirports As ArrayList = objConfigHandler.GetLocations("Airports")
    Dim tblResults As Hashtable = Application("Airport Weather Results")

    Dim objWeatherRequestManager As New classes.WeatherRequestManager(WEATHER_DATASOURCE)
    Dim arrResults As ArrayList

    Dim objAirport As classes.Location

    For Each objAirport In arrAirports

      Try
        arrResults = objWeatherRequestManager.FindWithin( _
                                            New classes.Point(objAirport.X, objAirport.Y), _
                                            SEARCH_RADIUS, _
                                            MAX_FEATURES, _
                                            Application("Token") _
                                            )
      Catch ex As Exception

        WriteToLog( _
                    "Error getting weather data for " & objAirport.ID & " airport: " & ex.Message, _
                    LogEntryStatus.Status_Error _
                   )

      End Try

      Try
        Application.Lock()
        tblResults.Remove(objAirport.ID)
        tblResults.Add(objAirport.ID, arrResults(0))
      Catch ex As Exception
        WriteToLog( _
                    "Error creating weather data entry for " & objAirport.ID & " airport: " & ex.Message, _
                    LogEntryStatus.Status_Error _
                   )
      Finally
        Application.UnLock()
      End Try

    Next

    WriteToLog( _
                "Finished airport weather data update.", _
                LogEntryStatus.Status_Information _
              )

  End Sub

  Private Sub Update_Airport_Map()

    Dim sURL As String = Nothing
    Dim objConfigHandler As New SectionHandler_Locations
    Dim arrAirports As ArrayList = objConfigHandler.GetLocations("Airports")

    WriteToLog( _
                "Beginning airport map update.", _
                LogEntryStatus.Status_Information _
              )

    Try
      sURL = MakeMap( _
                      arrAirports, _
                      Location_Type.ltAirport, _
                      ConfigurationSettings.AppSettings("AIRPORT_MAP_WIDTH"), _
                      ConfigurationSettings.AppSettings("AIRPORT_MAP_HEIGHT"), _
                      ConfigurationSettings.AppSettings("AIRPORT_ICON_DATASOURCE"), _
                      ConfigurationSettings.AppSettings("AIRPORT_ICON_NAME") _
                     )
    Catch ex As Exception
      WriteToLog( _
                  "Problem generating airport map.", _
                  LogEntryStatus.Status_Error _
                )
      Exit Sub
    End Try

    Try
      Application.Lock()
      Application("Airport Weather Map") = sURL
    Finally
      Application.UnLock()
    End Try

    WriteToLog( _
                "Finished airport map update.", _
                LogEntryStatus.Status_Information _
              )

  End Sub

  Private Sub Update_RO_Map()

    Dim sURL As String = Nothing
    Dim objConfigHandler As New SectionHandler_Locations
    Dim arrOffices As ArrayList = objConfigHandler.GetLocations("Offices")

    WriteToLog( _
                "Beginning RO map update.", _
                LogEntryStatus.Status_Information _
              )

    Try
      sURL = MakeMap( _
                      arrOffices, _
                      Location_Type.ltRegionalOffice, _
                      ConfigurationSettings.AppSettings("OFFICE_MAP_WIDTH"), _
                      ConfigurationSettings.AppSettings("OFFICE_MAP_HEIGHT"), _
                      ConfigurationSettings.AppSettings("OFFICE_ICON_DATASOURCE"), _
                      ConfigurationSettings.AppSettings("OFFICE_ICON_NAME") _
                      )
    Catch ex As Exception
      WriteToLog( _
                  "Problem generating RO map.", _
                  LogEntryStatus.Status_Error _
                )
      Exit Sub
    End Try

    Try
      Application.Lock()
      Application("RO Weather Map") = sURL
    Finally
      Application.UnLock()
    End Try

    WriteToLog( _
                "Finished RO map update.", _
                LogEntryStatus.Status_Information _
              )

  End Sub

  Private Sub Update_RO_WeatherData()

    WriteToLog( _
                "Beginning RO weather data update.", _
                LogEntryStatus.Status_Information _
              )

    Dim objConfigHandler As New SectionHandler_Locations
    Dim arrOffices As ArrayList = objConfigHandler.GetLocations("Offices")
    Dim tblResults As Hashtable = Application("RO Weather Results")

    Dim objWeatherRequestManager As New classes.WeatherRequestManager(WEATHER_DATASOURCE)
    Dim arrResults As ArrayList

    Dim objOffice As classes.Location

    For Each objOffice In arrOffices

      Try
        arrResults = objWeatherRequestManager.FindWithin( _
                                            New classes.Point(objOffice.X, objOffice.Y), _
                                            SEARCH_RADIUS, _
                                            MAX_FEATURES, _
                                            Application("Token") _
                                            )
      Catch ex As Exception

        WriteToLog( _
                    "Error getting weather data for " & objOffice.ID & " office: " & ex.Message, _
                    LogEntryStatus.Status_Error _
                   )

      End Try

      Try
        Application.Lock()
        tblResults.Remove(objOffice.ID)
        tblResults.Add(objOffice.ID, arrResults(0))
      Catch ex As Exception
        WriteToLog( _
                    "Error creating weather data entry for " & objOffice.ID & " office: " & ex.Message, _
                    LogEntryStatus.Status_Error _
                   )
      Finally
        Application.UnLock()
      End Try

    Next

    WriteToLog( _
                "Finished RO weather update.", _
                LogEntryStatus.Status_Information _
              )

  End Sub

  ' *********************************************************************
  ' *********************** PRIVATE FUNCTIONS ***************************
  ' *********************************************************************

  Private Function GetToken( _
                              ByVal sUserName As String, _
                              ByVal sPassWord As String, _
                              ByVal iTimeOut As Integer _
                            ) As String

    Dim objAuthentication As New ArcWeb_Authentication.Authentication
    Return objAuthentication.getToken(sUserName, sPassWord, iTimeOut)

  End Function

  Private Function MakeMap( _
                            ByVal arrLocations As ArrayList, _
                            ByVal Type As Location_Type, _
                            ByVal iWidth As Integer, _
                            ByVal iHeight As Integer, _
                            ByVal sIconDataSet As String, _
                            ByVal sIconName As String _
                            ) As String

    Dim sMapURL As String

    Dim arrMarkers As New ArrayList
    Dim mkrCurrent As classes.Marker
    Dim ptCurrent As classes.Point
    Dim lblCurrent As classes.Label

    Dim objLocation As classes.Location

    Dim sLabel As String

    For Each objLocation In arrLocations

      ptCurrent = New classes.Point( _
                                objLocation.X, _
                                objLocation.Y _
                                  )

      If Type = Location_Type.ltAirport Then
        sLabel = objLocation.ID
      Else
        sLabel = objLocation.Name
      End If

      lblCurrent = New classes.Label( _
                                  sLabel, _
                                  "Verdana", _
                                  8, _
                                  "255,255,255", _
                                  classes.Label.TextAlignment.alignRight, _
                                  False, _
                                  2, _
                                  "255,0,0" _
                                    )

      mkrCurrent = New classes.Marker( _
                                      ptCurrent, _
                                      sIconName, _
                                      sIconDataSet, _
                                      lblCurrent _
                                      )

      arrMarkers.Add(mkrCurrent)

    Next

    Dim rctExtent As New classes.Rect( _
            CDbl(ConfigurationSettings.AppSettings("DEFAULT_EXTENT_XMIN")), _
            CDbl(ConfigurationSettings.AppSettings("DEFAULT_EXTENT_YMIN")), _
            CDbl(ConfigurationSettings.AppSettings("DEFAULT_EXTENT_XMAX")), _
            CDbl(ConfigurationSettings.AppSettings("DEFAULT_EXTENT_YMAX")) _
                                      )

    Dim objMapImageRequest As New classes.MapImageLayer( _
                                                      "Weather Map", _
                                                      "MX.Precipitation.US", _
                                                      True _
                                                        )

    objMapImageRequest.SetLayerVisibility("U.S. Cities", False)
    objMapImageRequest.SetLayerVisibility("Current Precipitation", True)

    sMapURL = objMapImageRequest.GetMap( _
                                rctExtent, _
                                iWidth, _
                                iHeight, _
                                arrMarkers, _
                                Application("Token") _
                                                )

    Return sMapURL

  End Function

  Private Sub WriteToLog( _
                          ByVal msg As String, _
                          ByVal status As LogEntryStatus _
                          )


    If CBool(ConfigurationSettings.AppSettings("LOGGING")) Then
      ' implement logging here.
    End If

  End Sub

End Class
