Option Strict On

Imports System
Imports System.Collections
Imports System.Xml
Imports System.Configuration
Imports System.Reflection
Imports classes

Public Class SectionHandler_Locations

  Implements IConfigurationSectionHandler

  Public Function Create( _
                          ByVal parent As Object, _
                          ByVal configContext As Object, _
                          ByVal section As XmlNode _
                        ) As Object Implements IConfigurationSectionHandler.Create

    Dim lstNodes As XmlNodeList = section.SelectNodes("//Location")
    Dim objOfficeNode As XmlNode
    Dim arrOffices As New ArrayList

    For Each objOfficeNode In lstNodes
      With objOfficeNode.Attributes
        arrOffices.Add( _
                        New Location( _
                                    .GetNamedItem("id").Value, _
                                    .GetNamedItem("name").Value, _
                                    CDbl(.GetNamedItem("x").Value), _
                                    CDbl(.GetNamedItem("y").Value) _
                                    ) _
                      )
      End With
    Next

    Return arrOffices

  End Function

  Public Function GetLocation(ByVal ID As String, ByVal SectionName As String) As Location

    Dim arrOffices As ArrayList = Me.GetLocations(SectionName)
    Dim objOfficeFound As Location
    Dim objOfficeCurrent As Location

    For Each objOfficeCurrent In arrOffices
      If (UCase(objOfficeCurrent.ID) = UCase(ID)) Then
        objOfficeFound = objOfficeCurrent
        Exit For
      End If
    Next

    Return objOfficeFound

  End Function

  Public Function GetLocations(ByVal SectionName As String) As ArrayList

    Dim arrOffices As ArrayList = CType( _
                                        System. _
                                        Configuration. _
                                        ConfigurationSettings. _
                                        GetConfig(SectionName), _
                                        ArrayList _
                                       )

    Return arrOffices

  End Function

End Class
