Public Class PlaceHolder

  Inherits System.Web.UI.Page

  Public m_sNavToPage

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub
Protected WithEvents imgMap As System.Web.UI.WebControls.Image
Protected WithEvents imgLegend As System.Web.UI.WebControls.Image
Protected WithEvents lblTitle As System.Web.UI.WebControls.Label
Protected WithEvents tblResults As System.Web.UI.WebControls.Table


    'NOTE: The following placeholder declaration is required by the Web Form Designer.
    'Do not delete or move it.
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region


  Private Sub Page_PreRender( _
                              ByVal sender As Object, _
                              ByVal e As System.EventArgs _
                            ) Handles MyBase.PreRender

    Dim sOffice = Request.QueryString("OFFICE")
    Dim sTimeZoneOffset = Request.QueryString("TIMEOFFSET")

    If (sOffice = "") Then
      lblTitle.Visible = True
      lblTitle.Text = "ERROR... No location specified."
      Exit Sub
    End If

    If (sTimeZoneOffset = "") Then
      lblTitle.Visible = True
      lblTitle.Text = "ERROR... No time zone offset specified."
      Exit Sub
    End If


    m_sNavToPage = "details.aspx" & _
                   "?OFFICE=" & sOffice & _
                   "&TIMEOFFSET=" & sTimeZoneOffset

    sOffice = UCase(sOffice).Split("_").GetValue(1)

    Dim tblROWeatherResults As Hashtable = Application("RO Weather Results")
    Dim objWeatherResult As classes.WeatherResult = tblROWeatherResults.Item(sOffice)

    Dim objConfigHandler As New SectionHandler_Locations
    Dim objOffice As classes.Location = objConfigHandler.GetLocation(sOffice, "Offices")

    If objWeatherResult Is Nothing Then
        lblTitle.Visible = True
        lblTitle.Text = "ERROR... Invalid Location Specified."
        Exit Sub
    Else
        lblTitle.Visible = False
    End If

    Dim dtObservationTime As DateTime = GetTime( _
                                                 objWeatherResult.ObservationTime, _
                                                 CInt(sTimeZoneOffset) _
                                                )

    Dim sLocation As String
    If objWeatherResult.City = "NULL" Then
      sLocation = objWeatherResult.County
    Else
      sLocation = objWeatherResult.City
    End If

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Office:", _
                                    objOffice.Name _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Conditions:", _
                                    objWeatherResult.Description _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Temperature:", _
                                    Math.Round(objWeatherResult.Temperature).ToString & " F" _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Humidity:", _
                                    objWeatherResult.Humidity.ToString & "%" _
                                    ) _
                        )


    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Visibility:", _
                                    objWeatherResult.Visibility.ToString & " mi." _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Dew Point:", _
                                    Math.Round(objWeatherResult.DewPoint).ToString & " F" _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Pressure:", _
                                    objWeatherResult.Pressure.ToString & " mb" _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Wind:", _
                                    objWeatherResult.Formatted_Wind _
                                    ) _
                        )

    tblResults.Rows.Add( _
                         CreateDescriptionRow( _
                                               dtObservationTime, _
                                               sLocation, _
                                               objWeatherResult.State _
                                               ) _
                       )


  End Sub

  Private Function CreateDescriptionRow( _
                                         ByVal dtObservationTime As DateTime, _
                                         ByVal sLocation As String, _
                                         ByVal sState As String _
                                        )

    Dim celText As New TableCell
    celText.ColumnSpan = 2
    celText.CssClass = "detailscaption"

    celText.Text = "Reported at " & sLocation & ", " & sState & "<BR>" & _
                   "on " & dtObservationTime.ToLongDateString & "<BR>" & _
                   "at " & dtObservationTime.ToLongTimeString & "."

    Dim rowDesc As New TableRow
    rowDesc.Cells.Add(celText)

    Return rowDesc

  End Function

  Private Function CreateRow(ByVal sTitle As String, ByVal sContent As String)

    Dim celTitle As New TableCell
    celTitle.CssClass = "weathertitlecell"
    celTitle.Text = sTitle

    Dim celContent As New TableCell
    celContent.CssClass = "weathercontentcell"
    celContent.Text = sContent

    Dim aRow As New TableRow
    aRow.Cells.Add(celTitle)
    aRow.Cells.Add(celContent)

    Return aRow

  End Function

  Private Function GetTime( _
                            ByVal sDateTime As String, _
                            ByVal iOffsetMinutes As Integer _
                          ) As DateTime

    Dim sDate = sDateTime.Split(" ")(0)
    Dim sTime = sDateTime.Split(" ")(1)


    Dim iMonth As Integer = CInt(sDate.Split("/")(0))
    Dim iDay As Integer = CInt(sDate.Split("/")(1))
    Dim iYear As Integer = CInt(sDate.Split("/")(2))

    Dim iHours As Integer = CInt(sTime.split(":")(0))
    Dim iMinutes As Integer = CInt(sTime.split(":")(1))
    Dim iSeconds As Integer = CInt(sTime.split(":")(2))

    Dim spanDiff As New TimeSpan((iOffsetMinutes \ 60), iOffsetMinutes Mod 60, 0)

    Dim datGreenwich As New DateTime(iYear, iMonth, iDay, iHours, iMinutes, iSeconds)
    Dim datAdjusted As DateTime = datGreenwich.Subtract(spanDiff)

    Return datAdjusted

  End Function

End Class