Imports System.Threading
Imports classes

Public Class airports

  Inherits System.Web.UI.Page

  Protected WithEvents imgMap As System.Web.UI.WebControls.Image
  Protected WithEvents imgLegend As System.Web.UI.WebControls.Image
  Protected WithEvents tblOffices As System.Web.UI.WebControls.Table
  Protected WithEvents frmWeather As System.Web.UI.HtmlControls.HtmlForm

  Protected WithEvents lnkAirports As System.Web.UI.HtmlControls.HtmlAnchor
  Protected WithEvents lnkOffices As System.Web.UI.HtmlControls.HtmlAnchor
  Protected WithEvents lnkAbout As System.Web.UI.HtmlControls.HtmlAnchor

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub


    'NOTE: The following placeholder declaration is required by the Web Form Designer.
    'Do not delete or move it.
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

    ' *****************************************************************
    ' *************************** EVENTS ******************************
    ' *****************************************************************

  Private Sub Page_PreRender( _
                              ByVal sender As Object, _
                              ByVal e As System.EventArgs _
                            ) Handles MyBase.PreRender

      ' Read airports from config file.

    Dim objConfigHandler As New SectionHandler_Locations
    Dim arrAirports As ArrayList = objConfigHandler.GetLocations("Airports")

      ' Grab airport weather results from application
      ' object.  These weather results get updated at
      ' intervals based on the settings in the config
      ' file.

    Dim tblWeatherData_Airports As Hashtable = Application("Airport Weather Results")

      ' Each weather result object is stored under the
      ' office ID to which it corresponds.  

      ' Loop through the arraylist of airports, find the
      ' corresponding weather results, and write out 
      ' information.

    Dim iCount As Integer = 0
    Dim objAirport As Location
    Dim objResult As WeatherResult

    Dim aRow As TableRow
    Dim aCell1 As TableCell
    Dim aCell2 As TableCell
    Dim aCell3 As TableCell
    Dim aCell4 As TableCell
    Dim aCell5 As TableCell

    Dim sTemp As String
    Dim sConditions As String

    For Each objAirport In arrAirports

      iCount = iCount + 1

      objResult = tblWeatherData_Airports(objAirport.ID)

      If objResult Is Nothing Then
        ' For some reason, the last query failed for this
        ' airport, so the airport result wasn't in the 
        ' hashtable.
        sTemp = "No Data"
        sConditions = "No Data"
      Else
        sTemp = objResult.Temperature
        sConditions = objResult.Description
      End If

      aRow = New TableRow
      If (iCount Mod 2 = 0) Then
          aRow.CssClass = "airportrowshaded"
      End If

        'The Name...

      aCell1 = New TableCell
      aCell1.Text = objAirport.Name
      aCell1.CssClass = "airportname"
      aRow.Cells.Add(aCell1)

        'The Call Letters...

      aCell2 = New TableCell
      aCell2.Text = objAirport.ID
      aCell2.CssClass = "airportcallletters"
      aRow.Cells.Add(aCell2)

        'The Temp...  
      aCell3 = New TableCell
      aCell3.Text = sTemp
      aCell3.CssClass = "airporttemp"
      aRow.Cells.Add(aCell3)

        'The Conditions
      aCell4 = New TableCell
      aCell4.Text = sConditions
      aCell4.CssClass = "airportconditions"
      aRow.Cells.Add(aCell4)

      'The Link...
      aCell5 = New TableCell
      aCell5.CssClass = "airportlink"
      aCell5.Text = "<A href=""javascript:GoAirportMap('" & objAirport.ID & "')"">FAA Status</A>"
      aRow.Cells.Add(aCell5)

      tblOffices.Rows.Add(aRow)

    Next

    ' Populate map image url with URL stored in application object.

    imgMap.Width = New System.Web.UI.WebControls.Unit(ConfigurationSettings.AppSettings("AIRPORT_MAP_WIDTH"))
    imgMap.Height = New System.Web.UI.WebControls.Unit(ConfigurationSettings.AppSettings("AIRPORT_MAP_HEIGHT"))

    Dim sMapURL As String = Application("Airport Weather Map")
    If Not sMapURL Is Nothing Then
      imgMap.ImageUrl = sMapURL
    End If

    imgMap.AlternateText = "Current Precipitation Map from Meteorlogix, LCC."

  End Sub


  Private Sub lnkAirports_ServerClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkAirports.ServerClick
    Server.Transfer("airports.aspx")
  End Sub

  Private Sub lnkOffices_ServerClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkOffices.ServerClick
    Server.Transfer("offices.aspx")
  End Sub

  Private Sub lnkAbout_ServerClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkAbout.ServerClick
    Server.Transfer("about.aspx")
  End Sub

End Class
