Imports classes

Public Class details

  Inherits System.Web.UI.Page

  Private Const ICON_DATASOURCE = "ESRI.Raster.Icons"
  Private Const ICON_NAME = "cross_red.gif"

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub
    Protected WithEvents lblTitle As System.Web.UI.WebControls.Label
    Protected WithEvents imgMap As System.Web.UI.WebControls.Image
    Protected WithEvents imgLegend As System.Web.UI.WebControls.Image
    Protected WithEvents tblResults As System.Web.UI.WebControls.Table

    'NOTE: The following placeholder declaration is required by the Web Form Designer.
    'Do not delete or move it.
    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

  Private Sub Page_PreRender( _
                              ByVal sender As Object, _
                              ByVal e As System.EventArgs _
                              ) Handles MyBase.PreRender

    Dim sOffice = Request.QueryString("OFFICE")
    Dim sTimeZoneOffset = Request.QueryString("TIMEOFFSET")

    If (sOffice = "") Then
      lblTitle.Visible = True
      lblTitle.Text = "ERROR... No location specified."
      Exit Sub
    End If

    If (sTimeZoneOffset = "") Then
      lblTitle.Visible = True
      lblTitle.Text = "ERROR... No time zone offset specified."
      Exit Sub
    End If

    sOffice = UCase(sOffice).Split("_").GetValue(1)

    Dim tblROWeatherResults As Hashtable = Application("RO Weather Results")
    Dim objWeatherResult As classes.WeatherResult = tblROWeatherResults.Item(sOffice)

    Dim objConfigHandler As New SectionHandler_Locations
    Dim objOffice As classes.Location = objConfigHandler.GetLocation(sOffice, "Offices")

    If objWeatherResult Is Nothing Then
        lblTitle.Visible = True
        lblTitle.Text = "ERROR... Invalid Location Specified."
        Exit Sub
    Else
        lblTitle.Visible = False
    End If

    Dim dtObservationTime As DateTime = GetTime( _
                                                 objWeatherResult.ObservationTime, _
                                                 CInt(sTimeZoneOffset) _
                                                )

    Dim sLocation As String
    If objWeatherResult.City = "NULL" Then
      sLocation = objWeatherResult.County
    Else
      sLocation = objWeatherResult.City
    End If

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Office:", _
                                    objOffice.Name _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Conditions:", _
                                    objWeatherResult.Description _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Temperature:", _
                                    Math.Round(objWeatherResult.Temperature).ToString & " F" _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Humidity:", _
                                    objWeatherResult.Humidity.ToString & "%" _
                                    ) _
                        )


    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Visibility:", _
                                    objWeatherResult.Visibility.ToString & " mi." _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Dew Point:", _
                                    Math.Round(objWeatherResult.DewPoint).ToString & " F" _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Pressure:", _
                                    objWeatherResult.Pressure.ToString & " mb" _
                                    ) _
                        )

    tblResults.Rows.Add( _
                          CreateRow( _
                                    "Wind:", _
                                    objWeatherResult.Formatted_Wind _
                                    ) _
                        )

    tblResults.Rows.Add( _
                         CreateDescriptionRow( _
                                               dtObservationTime, _
                                               sLocation, _
                                               objWeatherResult.State _
                                               ) _
                       )

    'Get the Map...

    imgMap.ImageUrl = MakeMap( _
                              imgMap.Height.Value, _
                              imgMap.Width.Value, _
                              objOffice.Y, _
                              objOffice.X, _
                              objOffice.Name _
                              )

    imgMap.AlternateText = "Current Precipitation Map from Meteorlogix, LCC."

  End Sub

  Private Function CreateDescriptionRow( _
                                         ByVal dtObservationTime As DateTime, _
                                         ByVal sLocation As String, _
                                         ByVal sState As String _
                                        )

    Dim celText As New TableCell
    celText.ColumnSpan = 2
    celText.CssClass = "detailscaption"

    celText.Text = "Reported at " & sLocation & ", " & sState & "<BR>" & _
                   "on " & dtObservationTime.ToLongDateString & "<BR>" & _
                   "at " & dtObservationTime.ToLongTimeString & "."

    Dim rowDesc As New TableRow
    rowDesc.Cells.Add(celText)

    Return rowDesc

  End Function

  Private Function CreateRow(ByVal sTitle As String, ByVal sContent As String)

    Dim celTitle As New TableCell
    celTitle.CssClass = "weathertitlecell"
    celTitle.Text = sTitle

    Dim celContent As New TableCell
    celContent.CssClass = "weathercontentcell"
    celContent.Text = sContent

    Dim aRow As New TableRow
    aRow.Cells.Add(celTitle)
    aRow.Cells.Add(celContent)

    Return aRow

  End Function


  Private Function GetTime( _
                            ByVal sDateTime As String, _
                            ByVal iOffsetMinutes As Integer _
                          ) As DateTime

    Dim sDate = sDateTime.Split(" ")(0)
    Dim sTime = sDateTime.Split(" ")(1)


    Dim iMonth As Integer = CInt(sDate.Split("/")(0))
    Dim iDay As Integer = CInt(sDate.Split("/")(1))
    Dim iYear As Integer = CInt(sDate.Split("/")(2))

    Dim iHours As Integer = CInt(sTime.split(":")(0))
    Dim iMinutes As Integer = CInt(sTime.split(":")(1))
    Dim iSeconds As Integer = CInt(sTime.split(":")(2))

    Dim spanDiff As New TimeSpan((iOffsetMinutes \ 60), iOffsetMinutes Mod 60, 0)

    Dim datGreenwich As New DateTime(iYear, iMonth, iDay, iHours, iMinutes, iSeconds)
    Dim datAdjusted As DateTime = datGreenwich.Subtract(spanDiff)

    Return datAdjusted

  End Function



  Private Function MakeMap( _
                            ByVal height As Integer, _
                            ByVal width As Integer, _
                            ByVal lat As Double, _
                            ByVal lon As Double, _
                            ByVal sLabeltext As String _
                          ) As String

      Dim wsMapImage As New ArcWeb_MapImage.MapImage
      Dim wsMapInfo As New ArcWeb_MapImage.MapImageInfo
      Dim wsImageOptions As New ArcWeb_MapImage.MapImageOptions
      Dim env As New ArcWeb_MapImage.Envelope

      'Set some image properties...
      wsImageOptions.dataSource = "MX.Precipitation.US"
      wsImageOptions.mapImageFormat = "PNG"
      wsImageOptions.returnLegend = False
      Dim mis As New ArcWeb_MapImage.MapImageSize
      mis.height = height
      mis.width = width
      wsImageOptions.mapImageSize = mis

      'Turn the Current Precipitation layer on...
      Dim lyrCurPrecip As New ArcWeb_MapImage.Layer
      lyrCurPrecip.layerName = "Current Precipitation"
      lyrCurPrecip.visibility = "on"
      Dim arrlayers() As ArcWeb_MapImage.Layer = {lyrCurPrecip}
      wsImageOptions.displayLayers = arrlayers

      'Add an icon for the office location...
      Dim aMarker As New ArcWeb_MapImage.MarkerDescription
      aMarker.iconDataSource = ICON_DATASOURCE
      aMarker.name = ICON_NAME
      Dim aPoint As New ArcWeb_MapImage.Point
      aPoint.x = lon
      aPoint.y = lat
      aMarker.location = aPoint
      aMarker.label = sLabeltext
      Dim lblDesc As New ArcWeb_MapImage.LabelDescription
      lblDesc.font = "Verdana"
      lblDesc.fontColor = "255,255,255"
      lblDesc.outlineColor = "255,0,0"
      lblDesc.fontSize = 12
      lblDesc.fontStyle = "bold"
      lblDesc.interval = 10
      lblDesc.antialiasing = True
      aMarker.labelDescription = lblDesc

      Dim markers(0) As ArcWeb_MapImage.MarkerDescription
      markers(0) = aMarker
      wsImageOptions.markers = markers

      'Set the extent...
      env.minx = lon - 2
      env.miny = lat - 2
      env.maxx = lon + 2
      env.maxy = lat + 2

      'Make the request for a map...
      wsMapInfo = wsMapImage.getMap(env, wsImageOptions, Application("Token"))

      'Set the Map's URL...
      MakeMap = wsMapInfo.mapUrl

  End Function

End Class
