Imports System.Threading
Imports classes

Public Class WeatherPage

  Inherits System.Web.UI.Page

  ' Note: This variable gets picked up by the client javascript
  '       and determines the page to which the "Details" pop-up
  '       window gets directed.  You can set it to point directly
  '       to details.aspx, or -- if you want a "Please Wait" count-down
  '       while the map is being generated, you can point it to wait.aspx,
  '       which in turn will re-direct to details.aspx once the map
  '       is complete.

  '       Note that wait.aspx is essentially a duplicate of details.aspx
  '       without the map.  So, if you make changes to details.aspx, you
  '       also need to keep wait.aspx in sync.

  Public DetailsLinkPage = "details.aspx"

  Private Const NUMBER_DISPLAY_COLUMNS = 4

  Protected WithEvents imgMap As System.Web.UI.WebControls.Image
  Protected WithEvents frmWeather As System.Web.UI.HtmlControls.HtmlForm
  Protected WithEvents tblOffices As System.Web.UI.WebControls.Table
  Protected WithEvents imgLegend As System.Web.UI.WebControls.Image

  Protected WithEvents lnkAirports As System.Web.UI.HtmlControls.HtmlAnchor
  Protected WithEvents lnkOffices As System.Web.UI.HtmlControls.HtmlAnchor
  Protected WithEvents lnkAbout As System.Web.UI.HtmlControls.HtmlAnchor

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub

    'NOTE: The following placeholder declaration is required by the Web Form Designer.
    'Do not delete or move it.

    Private designerPlaceholderDeclaration As System.Object

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

    ' *****************************************************************
    ' *************************** EVENTS ******************************
    ' *****************************************************************

  Private Sub Page_PreRender( _
                              ByVal sender As Object, _
                              ByVal e As System.EventArgs _
                             ) Handles MyBase.PreRender

      ' Read offices from config file.

    Dim objConfigHandler As New SectionHandler_Locations
    Dim arrOffices As ArrayList = objConfigHandler.GetLocations("Offices")

      ' Grab office weather results from application
      ' object.  These weather results get updated at
      ' intervals based on the settings in the config
      ' file.

    Dim tblWeatherData_RO As Hashtable = Application("RO Weather Results")

      ' Each weather result object is stored under the
      ' office ID to which it corresponds.  

      ' Loop through the arraylist of airports, find the
      ' corresponding weather results, and write out 
      ' information.

    Dim iCount As Integer = 0
    Dim iNumCols As Integer = NUMBER_DISPLAY_COLUMNS
    Dim objOffice As Location
    Dim objResult As WeatherResult

    Dim tblWeather As Table
    Dim aCell As TableCell
    Dim aRow As TableRow = Nothing

    For Each objOffice In arrOffices

      iCount = iCount + 1

      If iCount Mod iNumCols = 1 Then
        aRow = New TableRow
        tblOffices.Rows.Add(aRow)
      End If

      objResult = tblWeatherData_RO(objOffice.ID)

      If objResult Is Nothing Then
        ' For some reason, the last query failed for this
        ' airport, so the airport result wasn't in the 
        ' hashtable.
        tblWeather = MakeNoDataTable(objOffice.Name)
      Else
        tblWeather = MakeWeatherTable(objResult.ID, _
                                      objOffice.ID, _
                                      objOffice.Name, _
                                      "images\" & objResult.Image, _
                                      objResult.Description, _
                                      objResult.Temperature)
      End If

      aCell = New TableCell
      aCell.Controls.Add(tblWeather)

      aRow.Cells.Add(aCell)

    Next

    ' Populate map image url with URL stored in application object.

    imgMap.Width = New System.Web.UI.WebControls.Unit(ConfigurationSettings.AppSettings("OFFICE_MAP_WIDTH"))
    imgMap.Height = New System.Web.UI.WebControls.Unit(ConfigurationSettings.AppSettings("OFFICE_MAP_HEIGHT"))

    Dim sMapURL As String = Application("RO Weather Map")
    If Not sMapURL Is Nothing Then
      imgMap.ImageUrl = Application("RO Weather Map")
    End If

    imgMap.AlternateText = "Current Precipitation Map from Meteorlogix, LCC."


  End Sub

  Private Sub lnkAirports_ServerClick( _
                                        ByVal sender As Object, _
                                        ByVal e As System.EventArgs _
                                      ) Handles lnkAirports.ServerClick
    Server.Transfer("airports.aspx")
  End Sub

  Private Sub lnkOffices_ServerClick( _
                                      ByVal sender As Object, _
                                      ByVal e As System.EventArgs _
                                      ) Handles lnkOffices.ServerClick
    Server.Transfer("offices.aspx")
  End Sub

  Private Sub lnkAbout_ServerClick( _
                                    ByVal sender As Object, _
                                    ByVal e As System.EventArgs _
                                  ) Handles lnkAbout.ServerClick
    Server.Transfer("about.aspx")
  End Sub

    ' *****************************************************************
    ' ********************* PRIVATE FUNCTIONS *************************
    ' *****************************************************************

  Private Function MakeNoDataTable(ByVal sName As String) As Table

      Dim newTable As New Table
      Dim row1 As New TableRow
      Dim row2 As New TableRow
      Dim row3 As New TableRow

      newTable.CssClass = "subtable"
      newTable.CellPadding = 1
      newTable.CellSpacing = 3

      Dim titleCell As New TableCell
      titleCell.CssClass = "titlecell"
      titleCell.Text = sName
      titleCell.ColumnSpan = 2
      row1.Cells.Add(titleCell)

      Dim curimgCell As New TableCell
      curimgCell.CssClass = "curimgcell"
      curimgCell.Text = "<IMG src='images/nodata.gif' />"
      row2.Cells.Add(curimgCell)

      Dim blanktextCell As New TableCell
      blanktextCell.CssClass = "curtextcell"
      blanktextCell.Text = "&nbsp;"
      row3.Cells.Add(blanktextCell)

      'Add the rows
      newTable.Rows.Add(row1)
      newTable.Rows.Add(row2)
      newTable.Rows.Add(row3)

      Return newTable

  End Function

  Private Function MakeWeatherTable( _
                                      ByVal sStationAbrev As String, _
                                      ByVal sOfficeName_Abbrev As String, _
                                      ByVal sOfficeName_Long As String, _
                                      ByVal sIcon As String, _
                                      ByVal sWeatherDescription As String, _
                                      ByVal dblTemperature As Double _
                                    ) As Table
      Dim newTable As New Table
      Dim row1 As New TableRow
      Dim row2 As New TableRow
      Dim row3 As New TableRow

      newTable.CssClass = "subtable"
      newTable.CellPadding = 1
      newTable.CellSpacing = 3

      Dim titleCell As New TableCell
      titleCell.CssClass = "titlecell"
      titleCell.Text = sOfficeName_Long
      titleCell.ColumnSpan = 2
      row1.Cells.Add(titleCell)

      Dim curimgCell As New TableCell
      curimgCell.CssClass = "curimgcell"
      curimgCell.Text = "<IMG src='" & sIcon & "' />"
      row2.Cells.Add(curimgCell)

      Dim tempCell As New TableCell
      tempCell.CssClass = "tempcell"
      tempCell.Text = Math.Round(dblTemperature).ToString & " F"
      row2.Cells.Add(tempCell)

      Dim curtextCell As New TableCell
      curtextCell.CssClass = "curtextcell"
      curtextCell.Text = sWeatherDescription
      row3.Cells.Add(curtextCell)

      Dim detailsCell As New TableCell
      Dim sJScript As String = "showDetails('" & sOfficeName_Abbrev & "');"

      detailsCell.CssClass = "detailcell"
      detailsCell.Text = "<A href=" & Chr(34) & "javascript:" & sJScript & Chr(34) & ">Details</A>"
      row3.Cells.Add(detailsCell)

      'Add the rows
      newTable.Rows.Add(row1)
      newTable.Rows.Add(row2)
      newTable.Rows.Add(row3)

      Return newTable

  End Function

End Class

