import arcpy
import random
import math
import os
import shutil
import arcgisscripting


newpath = r"C:\\geomask_data\\"
if not os.path.exists(newpath): os.makedirs(newpath)

arcpy.env.overwriteOutput = True



def setupRingMap():
    basepolygon = arcpy.GetParameterAsText(0)
    ringnumber = arcpy.GetParameter(1)
    outputmap = arcpy.GetParameterAsText(2)
    

    RingMap(basepolygon,ringnumber,outputmap)

def RingMap(basepolygon,ringnumber,outputmap):
    ringnum = ringnumber
    input_polygon = basepolygon
    outputname = outputmap
    num_feature = 0
    sc = arcpy.SearchCursor(basepolygon)
    row = sc.next()
    while row:
        num_feature += 1
        row = sc.next()
        
        
    


    boundaryname = "C:\\geomask_data\\bound_diss.shp"
    arcpy.Dissolve_management(input_polygon,boundaryname)
    
    p_x = []
    p_y = []
    sc = arcpy.SearchCursor(boundaryname)
    #row = sc.next()
    #while row:
        #p_x.append(row.x)
        #p_y.append(row.y)
        #row = sc.next()

    for row in sc:
        extent = row.Shape.extent

    a1 = extent.lowerLeft
    a2 = extent.lowerRight
    a3 = extent.upperRight
    a4 = extent.upperLeft

    b1 = str(a1)
    b2 = str(a2)
    b3 = str(a3)
    b4 = str(a4)
    i1 = 0
    i2 = 0
    i3 = 0
    i4 = 0
    p1 = []
    p2 = []
    p3 = []
    p4 = []

    num = 0
    while i1 < len(b1):
        c = b1[i1]
        
        if c == " ":
            p1.append(float(b1[num:i1]))
            num = i1

        if c == "N":
            i1 = len(b1)
        i1 += 1

    num = 0
    while i3 < len(b3):
        c = b3[i3]
        
        if c == " ":
            p3.append(float(b3[num:i3]))
            num = i3

        if c == "N":
            i3 = len(b3)
        i3 += 1
        
    
    

    
        


    minx = p1[0]
    maxx = p3[0]
    miny = p1[1]
    maxy = p3[1]
    centerx = (minx + maxx) /2
    centery = (miny + maxy) /2
    diameter = ((maxx - minx)**2 + (maxy - miny)**2) **0.5
    radius = diameter / 2
    error = radius / ringnum
    pt = arcpy.Point()
    pt.X = centerx
    pt.Y = centery
    ptGeoms = []
    ptGeoms.append(arcpy.PointGeometry(pt) )
    output = r"C:\\geomask_data\\center.shp"
    arcpy.CopyFeatures_management(ptGeoms, output )

    ringlist = []

    turns = 0
    while turns <ringnum:
        buffername = r"C:\\geomask_data\\center_buffer" + str(turns) + ".shp"
        output = r"C:\\geomask_data\\center.shp"
        arcpy.Buffer_analysis(output,buffername,radius + turns*error)

        ringname = r"C:\\geomask_data\\center_buffer_ring" + str(turns) + ".shp" 

    # nmultiple ringA]buffer, outside only
        arcpy.Buffer_analysis(buffername,ringname,error,"OUTSIDE_ONLY")
    
    #arcpy.MultipleRingBuffer_analysis(buffername,ringname,error,"Default","","ALL","OUTSIDE_ONLY")

        arcpy.SplitLine_management(ringname,"C:\\geomask_data\\line_ring2.shp")

        ringlinename = "C:\\geomask_data\\unsplitline_ring2.shp"
        arcpy.UnsplitLine_management("C:\\geomask_data\\line_ring2.shp",ringlinename)

#   즹ringpolylineAU@BringWQGI


    #  ntable xy to polyline ӭninsert cursor
        i = 1
        newx = []
        newy = []
        outerx = []
        outery = []
        pi = math.pi
        linelist = []

        while i < (num_feature+1):
            theta = (360/num_feature)*i
            newx.append(centerx + radius *0.9* math.cos(theta*pi/180))
    
            newy.append(centery + radius *0.9* math.sin(theta*pi/180))
        # ͤI
            pt = arcpy.Point()
            pt.X = newx[i-1]
            pt.Y = newy[i-1]
            ptGeoms = []
            ptGeoms.append(arcpy.PointGeometry(pt) )
            output = r"C:\\geomask_data\\inner_point" + str(i) +   ".shp"
            arcpy.CopyFeatures_management(ptGeoms, output )

    
            outerx.append(centerx + (radius + error*(turns+1))*1.1 * math.cos(theta*pi/180))
            outery.append(centery + (radius + error*(turns+1))*1.1 * math.sin(theta*pi/180))

        # ͥ~I
            pt2 = arcpy.Point()
            pt2.X = outerx[i-1]
            pt2.Y = outery[i-1]
            ptGeoms2 = []
            ptGeoms2.append(arcpy.PointGeometry(pt2))
            output2 = r"C:\\geomask_data\\outer_point" + str(i) +  ".shp"
            arcpy.CopyFeatures_management(ptGeoms2, output2 )


        

        
        # Points to line
        # ~Imerge b points to line
            mergename = "C:\\geomask_data\\mergepoints" +str(i) + ".shp"
            arcpy.Merge_management([output,output2],mergename)
            linename =  "C:\\geomask_data\\pointstoline" +str(i) + ".shp"
            linelist.append(linename)
            arcpy.PointsToLine_management(mergename,linename)
            i += 1
# ̫Ҧline merge
        linelist.append(ringlinename)
        allLine = "C:\\geomask_data\\allLine.shp"
        arcpy.Merge_management(linelist,allLine)
    # ̫BJ feature to polygon
        polygon_name = "C:\\geomask_data\\linetopolygon.shp"
        arcpy.FeatureToPolygon_management(allLine,polygon_name)
    
    # Acenter_bufer_ring Ӥ clip
        clipoutput = "C:\\geomask_data\\ring_clip" + str(turns) + ".shp"
        ringlist.append(clipoutput)
        
        arcpy.Clip_analysis(polygon_name,ringname,clipoutput)
        
        turns += 1

    allring = "C:\\geomask_data\\allring.shp"
    arcpy.Merge_management(ringlist,outputname)
    
    
    

    
        
    
    
    
        
    





if __name__ == "__main__":
    setupRingMap()
    #shutil.rmtree(newpath)    

    













    



