
import arcpy
import random
import math
import os
import shutil
import arcgisscripting


newpath = r"C:\\geomask_data\\"
if not os.path.exists(newpath): os.makedirs(newpath)

arcpy.env.overwriteOutput = True

def setupRingMap():
    basepolygon = arcpy.GetParameterAsText(0)
    ringpolygon = arcpy.GetParameterAsText(1)
    outputmap = arcpy.GetParameterAsText(2)
    RingMap(basepolygon,ringpolygon,outputmap)

    
    
def RingMap(basepolygon,ringpolygon,outputmap):
    input_polygon = basepolygon
    ringname = ringpolygon
    outputname = outputmap
    

# U@BGӥߪI M Wparts
    #I MͥߪI
    p_x = []
    p_y = []
    p2_x = []
    p2_y = []
    counts = 0
    sc = arcpy.SearchCursor(input_polygon)
    
    row = sc.next()
    while row:

        counts += 1
        row = sc.next()
    i = 0
    j = 0
        
    while i < counts:
        j = i +1
        
        gp = arcgisscripting.create()
        gp.SelectLayerbyAttribute(input_polygon,"NEW_SELECTION",'\"FID\" = %s' % i)
        sc = arcpy.SearchCursor(input_polygon)
        for row in sc:
            extent = row.Shape.extent
        a1 = extent.lowerLeft
        a2 = extent.lowerRight
        a3 = extent.upperRight
        a4 = extent.upperLeft

        b1 = str(a1)
        b2 = str(a2)
        b3 = str(a3)
        b4 = str(a4)
        i1 = 0
        i2 = 0
        i3 = 0
        i4 = 0
        p1 = []
        p2 = []
        p3 = []
        p4 = []

        num = 0
        while i1 < len(b1):
            c = b1[i1]
        
            if c == " ":
                p1.append(float(b1[num:i1]))
                num = i1

            if c == "N":
                i1 = len(b1)
            i1 += 1

        num = 0
        while i3 < len(b3):
            c = b3[i3]
        
            if c == " ":
                p3.append(float(b3[num:i3]))
                num = i3

            if c == "N":
                i3 = len(b3)
            i3 += 1
        
    
    

    
        


        minx = p1[0]
        maxx = p3[0]
        miny = p1[1]
        maxy = p3[1]
        meanx = (minx + maxx) /2
        meany = (miny+maxy) /2
        p_x.append(meanx)
        p_y.append(meany)
        #countmatch.append(meanx)
        pt = arcpy.Point()
        pt.X = meanx
        pt.Y = meany
        ptGeoms = []
        
        ptGeoms.append(arcpy.PointGeometry(pt) )
        output = r"C:\\geomask_data\\ring_center" + str(j) +   ".shp"
        #arcpy.CopyFeatures_management(ptGeoms, output )
        gp.SelectLayerByAttribute_management(input_polygon, "CLEAR_SELECTION", "")


        
        
        i += 1


    

    i = 0
    while i < len(p_x):
        
        pt = arcpy.Point()
        pt.X = p_x[i]
        pt.Y = p_y[i]
        ptGeoms = []
        ptGeoms.append(arcpy.PointGeometry(pt) )
        output = r"C:\\geomask_data\\each_center" + str(i) +   ".shp"
        arcpy.CopyFeatures_management(ptGeoms, output )
        i += 1

    #I
    arcpy.AddField_management(ringname,"ffid","LONG"  )
    i = 0
    uc = arcpy.UpdateCursor( ringname )
    row = uc.next()
    while row:
        row.ffid = i
        uc.updateRow(row)
        row = uc.next()
        i += 1
        
    

        
    i = 0
    j = 0
    
    ring_x = []
    ring_y = []
    
    
    while i < len(p_x):
        j = i +1
        
        gp = arcgisscripting.create()
        gp.SelectLayerbyAttribute(ringname,"NEW_SELECTION",'\"ffid\" = %s' % i)
        sc = arcpy.SearchCursor(ringname)
        for row in sc:
            extent = row.Shape.extent
        a1 = extent.lowerLeft
        a2 = extent.lowerRight
        a3 = extent.upperRight
        a4 = extent.upperLeft

        b1 = str(a1)
        b2 = str(a2)
        b3 = str(a3)
        b4 = str(a4)
        i1 = 0
        i2 = 0
        i3 = 0
        i4 = 0
        p1 = []
        p2 = []
        p3 = []
        p4 = []

        num = 0
        while i1 < len(b1):
            c = b1[i1]
        
            if c == " ":
                p1.append(float(b1[num:i1]))
                num = i1

            if c == "N":
                i1 = len(b1)
            i1 += 1

        num = 0
        while i3 < len(b3):
            c = b3[i3]
        
            if c == " ":
                p3.append(float(b3[num:i3]))
                num = i3

            if c == "N":
                i3 = len(b3)
            i3 += 1
        
    
    

    
        


        minx = p1[0]
        maxx = p3[0]
        miny = p1[1]
        maxy = p3[1]
        meanx = (minx + maxx) /2
        meany = (miny+maxy) /2
        ring_x.append(meanx)
        ring_y.append(meany)
        pt = arcpy.Point()
        pt.X = meanx
        pt.Y = meany
        ptGeoms = []
        
        ptGeoms.append(arcpy.PointGeometry(pt) )
        output = r"C:\\geomask_data\\ring_center" + str(j) +   ".shp"
        arcpy.CopyFeatures_management(ptGeoms, output )
        gp.SelectLayerByAttribute_management(ringname, "CLEAR_SELECTION", "")


        
        
        i += 1

    # {bp_x p_y ring_x ring_y
    #̪t ୫

    
    
    a = 0
    b = 0

    matchx = []
    matchy = []
    number = len(p_x)

    
    while a < number:
        
        dis = []
        b = 0
        
        
        while b < len(p_x):
            
            
            
            diff = ( (p_x[b] - ring_x[a])**2 + (p_y[b] - ring_y[a])**2 )**0.5
            
            dis.append(diff)
            b += 1
        b = 0
        dis.sort()
        mindis = dis[0]
        
        
        
        while b < len(p_x):
            diff = ( (p_x[b] - ring_x[a])**2 + (p_y[b] - ring_y[a])**2 )**0.5
            if diff == mindis:
                
                matchx.append(p_x[b])
                matchy.append(p_y[b])
               

                
                p_x.remove( p_x[b] )
                
                p_y.remove( p_y[b] )
                b = number
                
            b += 1
        
        if p_x == []:
            p_x = p2_x
            p_y = p2_y

        
        
        a += 1
    

    
        

    # matchI
    i = 0
    while i < number:
        pt = arcpy.Point()
        pt.X = matchx[i]
        pt.Y = matchy[i]
        ptGeoms = []
        ptGeoms.append(arcpy.PointGeometry(pt) )
        output = r"C:\\geomask_data\\matchpoint" + str(i) +   ".shp"
        arcpy.CopyFeatures_management(ptGeoms, output )
        i += 1
    
                
            
    

    
    i = 0
    linelist = []
    
    while i < len(ring_x):
        mergename = "C:\\geomask_data\\mergepoints" +str(i) + ".shp"
        
        
        output = r"C:\\geomask_data\\matchpoint" + str(i) +   ".shp"
        output2 =r"C:\\geomask_data\\ring_center" + str(i+1) +   ".shp"
        
        
        arcpy.Merge_management([output,output2],mergename)
        
        
        linename =  "C:\\geomask_data\\pointstoline" +str(i) + ".shp"
        linelist.append(linename)
        arcpy.PointsToLine_management(mergename,linename)
        i +=1
    
    arcpy.Merge_management(linelist, outputmap)
    


    # UpdataCursor townid

         
        
        
            
        


    


        

        


if __name__ == "__main__":
    setupRingMap()
    #shutil.rmtree(newpath)    

